/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalTooltips = Object.create(STBModule.prototype);

STBGlobalTooltips.name = "GlobalTooltips";
STBGlobalTooltips.initElements = function () {

	var tooltips = jQuery('[data-tooltip]:not(.__done)');

	tooltips.each(function() {
		var el = jQuery(this);

		if (el.attr("data-custom") ){

			el.tooltip({
				"container" : "body",
				"placement"	: STBUtils.attrDefaultValue(el.attr("data-position"), "top"),
				"title"		: function() {			
					return jQuery(this).find("> span").html();
				},
				"html"		: true,
				"template"	: '<div class="tooltip tooltip-custom" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
			});
		} else {
			el.tooltip({
				"container" : "body",
				"placement"	: STBUtils.attrDefaultValue(el.attr("data-position"), "top"),
				"title"		: el.attr("title"),
				"html"		: el.attr("data-html") == "true" ? true : false,
				"template"	: STBUtils.attrDefaultValue(el.attr("data-tooltip-template"), '<div class="tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'),

			});
		}
	});


	tooltips.addClass("__done");
}


STBGlobalTooltips.runOnReady = function() {
	STBGlobalTooltips.initElements();
}

STBGlobalTooltips.runOnContentUpdate = function() {
	STBGlobalTooltips.initElements();
}


site.registerModule(STBGlobalTooltips);
